start transaction;



DROP view if exists tbl_view_devicestotalforeachmonth_info ;
CREATE VIEW tbl_view_devicestotalforeachmonth_info AS
SELECT id,COUNT(id) as no ,MONTHNAME(date_added) AS month, YEAR(date_added)  AS year
FROM devices
group by month


DROP view if exists tbl_view_clientstotalforeachmonth_info ;
CREATE VIEW clientstotalforeachmonth_info AS
SELECT id,COUNT(id) as no,MONTHNAME(login_date) AS month, YEAR(login_date)  AS year
FROM content_users
group by month



DROP view if exists tbl_view_mass ;
CREATE VIEW tbl_view_mass AS
SELECT id,COUNT(id) as no,MONTHNAME(created_at) AS month, YEAR(created_at)  AS year,mass
FROM form
group by mass


DROP view if exists tbl_view_menu_list ;
CREATE VIEW tbl_view_menu_list AS
SELECT cu.id,cu.account_name,GROUP_CONCAT(di.device_name,'\n') as device_name
FROM content_users cu
left join devices di on di.content_id = cu.id
group by cu.id

DROP view if exists tbl_view_menu_list ;
CREATE VIEW tbl_view_menu_list AS
SELECT cu.id,cu.account_name,di.device_name as device_name
FROM content_users cu
left join devices di on di.content_id = cu.id
order by cu.id



SELECT GROUP_CONCAT(DISTINCT categories ORDER BY categories ASC SEPARATOR ' ') FROM table

DROP view if exists tbl_view_content_info ;
CREATE VIEW tbl_view_content_info AS
SELECT id,dateAdded,title,  concat(cat1, '>', cat2, ' >' , cat3) AS categories,image, user_id,body
FROM content


DROP view if exists tbl_view_profile_list ;
CREATE VIEW tbl_view_profile_list AS
SELECT us.id,cu.account_name,cu.account_type,cu.manager,cu.address,cu.country,
cu.city,us.username,us.email,us.phone,us.password,us.photo
FROM users us
join content_users cu on cu.user_id = us.id



DROP view if exists tbl_view_profile_list ;
CREATE VIEW tbl_view_profile_list AS
SELECT us.id,cu.account_name,cu.account_type,cu.manager,cu.address,cu.country,
cu.city,us.username,us.email,us.phone,us.password,us.photo
FROM users us
join content_users cu on cu.user_id = us.id



DROP view if exists tbl_view_statsinfo ;
CREATE VIEW tbl_view_statsinfo AS
SELECT id,activity as breakdown,COUNT(activity) as access_count,DATE(activityDate) as activityDate,section
FROM stats
group by activity

-- WHERE date_field >= LAST_DAY(CURRENT_DATE) + INTERVAL 1 DAY - INTERVAL 1 MONTH
--   AND date_field < LAST_DAY(CURRENT_DATE) + INTERVAL 1 DAY


DROP view if exists tbl_view_useractivity ;
CREATE VIEW tbl_view_useractivity AS
SELECT du.id,du.username,concat(du.firstname , ' ' , du.lastname) AS fullname
FROM device_users du
join stats st on st.deviceId = du.deviceId























DROP view if exists tbl_view_all_info ;
CREATE VIEW tbl_view_all_info AS
SELECT tp.personalinfo_id, concat(tp.other_names, '  ' , tp.surname) AS full_name,
		concat(tp.dob,'|', tp.pob) AS place_date_of_birth, concat(tp.email,'|' , tp.tel) AS contact_info,
		concat(tp.marital_status, '|' ,tp.marital_type) AS marital_status, concat(tp.societies ,'|', tp.dayborn)  AS societies,
		concat(tp.f_communion, '|', tp.h_communion, '|', tp.baptism) AS first_holy_communion_and_baptism,
		te.institution,   te.institute_name, te.institute_address, concat(te.course, '|', te.certificate) AS course_and_certificate,
		concat(te.academicto,'|', te.academicfrom) AS academic_to_and_from,
		teg.person,  teg.relationship, teg.typecontact,teg.address, concat(teg.email, ' ', teg.telnumber) AS emergency_contact,
		tn.baptism_place, tn.language, tn.church_join, tn.baptism_date, tn.hometown,
		tf.spouse, tf.spouse_occupation, tf.mother_name, tf.father_name, tf.spouse_nationality,
		concat(tf.spouse_tel,  ' ' , tf.spouse_email) AS spouse_contact_info,
		top.profession,  top.occupation, top.work_place, top.company_name,
		top.job_description,concat(top.company_address,  ' | ' , top.company_location, '|' , top.company_tel) AS company_contact_info
FROM tb_personalinfo tp
left join tb_education te on te.personalinfo_id = tp.personalinfo_id
left join tb_emergency teg on teg.personalinfo_id = tp.personalinfo_id
left join tb_nationalityinfo tn on tn.personalinfo_id = tp.personalinfo_id
left join  tb_familyinfo tf on tf.personalinfo_id = tp.personalinfo_id
left join tb_occupationinfo top on top.personalinfo_id = tp.personalinfo_id








DROP view if exists tbl_view_daily_sales ;
CREATE VIEW tbl_view_daily_sales AS
SELECT id,SUM(total) AS total,saledate
FROM sale_summary
 WHERE DATE(saledate) = CURDATE()


 DROP view if exists tbl_view_yesterday_sales ;
CREATE VIEW tbl_view_yesterday_sales AS
SELECT id,SUM(total)  AS yesti_sales, saledate
FROM sale_summary
WHERE DATE(saledate) = SUBDATE(CURDATE(),1)


DROP view if exists tbl_view_purchases_info ;
CREATE VIEW tbl_view_purchases_info AS
SELECT id,received_by,amount_received,purchases,MONTHNAME(date) AS month, YEAR(date)  AS year
FROM purchase_summary






DROP view if exists tbl_view_purchases_info ;
CREATE VIEW tbl_view_purchases_info AS
SELECT id,received_by,amount_received,purchases,MONTHNAME(date) AS month, YEAR(date)  AS year
FROM purchase_summary


DROP view if exists tbl_view_expenses ;
CREATE VIEW tbl_view_expenses AS
SELECT id,sum(total),date
FROM expenses


DROP view if exists tbl_view_sales_summary ;
CREATE VIEW tbl_view_sales_summary AS
SELECT id,total,cash,balance,saledate
FROM sale_summary




DROP view if exists tbl_view_purchases_select_date ;
CREATE VIEW tbl_view_purchases_select_date AS
SELECT id,GROUP_CONCAT(received_by) AS received_by,SUM(amount_received) AS amount_received, SUM(purchases) AS purchases ,
date,MONTHNAME(date) AS month, YEAR(date)  AS year
FROM purchase_summary
group by date




DROP view if exists tbl_view_purchases_table ;
CREATE VIEW tbl_view_purchases_table AS
SELECT ps.id, MONTHNAME(ps.date) AS month, YEAR(ps.date)  AS year, SUM(ps.amount_received) AS received_total, SUM(pi.price * pi.quantity)  AS purchases_total, SUM(ps.amount_received - (pi.price * pi.quantity)) AS variance
FROM purchase_summary ps
join purchase_item pi on pi.purchase_summary_id = ps.id
group by month




drop procedure if exists `proc_purchase_table` //

create procedure `proc_purchase_table`(in p_month varchar(50), in p_year varchar(50))
begin
	set @p_month= ifnull(p_month, null;
	set @p_year = ifnull(p_year, null);

	if @p_month= null then
		select id,amount_received,purchases,MONTHNAME(date) AS month, YEAR(date)  AS year,
		 SUM(amount_received) AS received_total, SUM(purchases) AS purchases_total,SUM(amount_received - purchases) AS variance
         FROM purchase_summary  GROuP BY  month
		where month=@p_month and
		year=p_year
		group by month ;

	end if;

end //


-- =================Product Details View==========================================

DROP view if exists tbl_view_product_details ;
CREATE VIEW  tbl_view_product_details AS
SELECT pd.*,ca.name AS category,pi.product_name  AS product_name, sp.name AS supplier, pi.price AS purchasing_price, (pi.price * pd.quantity) As stock
FROM products_details pd
join purchase_item pi on pi.id = pd.purchase_id
join category ca on ca.id = pi.category_id
join supplier sp on sp.id = pi.supplier_id



DROP view if exists tbl_view_sale_list ;
CREATE VIEW  tbl_view_sale_list AS
SELECT pd.product_name,pd.selling_price,do.quantity,(pd.selling_price * do.quantity) AS  sub_total,ss.total,ss.cash,ss.balance
FROM products_details pd
join double_sale do on do.product_id = pd.id
join sale_summary ss on ss.id = do.sale_id
group by do.sale_id



DROP view if exists tbl_view_sale_list ;
CREATE VIEW  tbl_view_sale_list AS
SELECT pi.product_name,pd.selling_price,do.quantity,(pd.selling_price * do.quantity) AS  sub_total,do.sale_id,do.product_id,ss.total,ss.cash,ss.balance
FROM products_details pd
join purchase_item pi on pi.id = pd.purchase_id
join double_sale do on do.product_id = pd.id
join sale_summary ss on ss.id = do.sale_id
group by do.sale_id


 -- $this->db->select_sum('total', 'total');
 --     $this->db->from($this->_table_name);
 --     $this->db->where('saledate BETWEEN "'. $from . '" and "'. $to .'"');
 --     $query = $this->db->get();
 --     return $query->result();



DROP view if exists tbl_view_double_dropdown_list ;
CREATE VIEW  tbl_view_double_dropdown_list AS
SELECT pd.*,pi.product_name
FROM products_details pd
join purchase_item pi on pi.id = pd.purchase_id

--....................... Main double sale list view used..........................

DROP view if exists tbl_view_sale_list ;
CREATE VIEW  tbl_view_sale_list AS
SELECT do.id, GROUP_CONCAT(pi.product_name) as product_name,GROUP_CONCAT(pd.selling_price) AS selling_price, GROUP_CONCAT(do.quantity) AS quantity,GROUP_CONCAT(pd.selling_price * do.quantity) AS  sub_total,do.sale_id,do.product_id,ss.total,ss.cash,ss.balance,do.created_at
FROM products_details pd
join purchase_item pi on pi.id = pd.purchase_id
join double_sale do on do.product_id = pd.id
join sale_summary ss on ss.id = do.sale_id
group by do.sale_id

--....................... Main purchase item  List used ..........................
DROP view if exists tbl_view_purchase_item_list ;
CREATE VIEW  tbl_view_purchase_item_list AS
SELECT pi.*, (pi.price * pi.quantity) AS total, ca.name  AS category, ss.name AS supplier, ps.received_by AS  received_by , ps.amount_received AS amount_received
FROM purchase_item pi
join category ca on ca.id = pi.category_id
join supplier ss on ss.id = pi.supplier_id
join purchase_summary ps on ps.id = pi.purchase_summary_id



DROP view if exists tbl_view_nationality_info ;
CREATE VIEW tbl_view_nationality_info AS
SELECT tn.nationality_id, tn.baptism_place, concat(tp.personalinfo_id, '.', tp.other_names, ' ' , tp.surname) AS full_name,  tn.language, tn.church_join, tn.baptism_date, tn.hometown
FROM tb_nationalityinfo tn
right join tb_personalinfo tp on tp.personalinfo_id = tn.personalinfo_id

DROP view if exists tbl_view_family_info ;
CREATE VIEW tbl_view_family_info AS
SELECT tn.familyinfo_id, tn.children_no, concat(tp.personalinfo_id, '.', tp.other_names, ' ' , tp.surname) AS full_name, tn.spouse, tn.spouse_occupation, tn.mother_name, tn.father_name, tn.spouse_nationality,concat(tn.spouse_tel,  ' ' , tn.spouse_email) AS spouse_contact_info
FROM tb_familyinfo tn
right join tb_personalinfo tp on tp.personalinfo_id = tn.personalinfo_id



DROP view if exists tbl_view_occupation_info ;
CREATE VIEW tbl_view_occupation_info AS
SELECT tn.occupation_id, tn.profession, concat(tp.personalinfo_id, '.', tp.other_names, ' ' , tp.surname) AS full_name,  tn.occupation, tn.work_place, tn.company_name, tn.job_description,concat(tn.company_address,  ' | ' , tn.company_location, '|' , tn.company_tel) AS company_contact_info
FROM tb_occupationinfo tn
right join tb_personalinfo tp on tp.personalinfo_id = tn.personalinfo_id


UPDATE tb_nationalityinfo t1
        INNER JOIN tb_personalinfo t2
             ON t1.nationality_id = t2.personalinfo_id
SET t1.personalinfo_id = t2.personalinfo_id


UPDATE vst_visitorotherdetails t1
        INNER JOIN vst_visitordetails t2
             ON t1.visitorotherdetails_id = t2.visitordetails_id
SET t1.visitordetails_id = t2.visitordetails_id



create or replace view `tbl_view_personal_info` AS select `personalinfo_id`.`surname`.`other_names` AS `name`,
	`pob`.`dob`.`age` AS `age_info`
	FROM tb_personalinfo;

create or replace view `bms_view_brokerage_orders` AS select `bms_brokerage_orders`.`brokerage_order_id` AS `brokerage_order_id`,
	`bms_brokerage_orders`.`branch_id` AS `branch_id`,
	`bms_brokerage_orders`.`client_account_id` AS `client_account_id`,
	`bms_brokerage_orders`.`instructions` AS `instructions`,
	`bms_brokerage_orders`.`equity_id` AS `equity_id`,
	`bms_brokerage_orders`.`order_number` AS `order_number`,
	`bms_brokerage_orders`.`reference_number` AS `reference_number`,
	`bms_brokerage_orders`.`consideration` AS `consideration`,
	`bms_brokerage_orders`.`order_price` AS `order_price`,
	`bms_brokerage_orders`.`market_price` AS `market_price`,
	`bms_brokerage_orders`.`balance` AS `balance`,
	`bms_brokerage_orders`.`quantity` AS `quantity`,
	`bms_brokerage_orders`.`amount` AS `amount`,
	`bms_brokerage_orders`.`charges` AS `charges`,
	`bms_brokerage_orders`.`transaction_date` AS `transaction_date`,
	`bms_brokerage_orders`.`order_type` AS `order_type`,
	`bms_brokerage_orders`.`order_status` AS `order_status`,
	`bms_brokerage_orders`.`comment` AS `comment`,
	`bms_brokerage_orders`.`charge_list` AS `charge_list`,
	`bms_brokerage_orders`.`created_at` AS `created_at`,
	`bms_brokerage_orders`.`created_by` AS `created_by`,
	`bms_brokerage_orders`.`updated_at` AS `updated_at`,
	`bms_brokerage_orders`.`updated_by` AS `updated_by`,
	/*`securities`.`security_code` AS `security_code`,*/`securities`.`security_description` AS `security_description`,
	`branches`.`branch_name` AS `branch_Name`,`bms_brokerage_orders`.`actual_quantity` AS `actual_quantity`,
	`clients`.`client_id` AS `client_id`,`clients`.`client_name` AS `client_name`,`clients`.`client_type` AS `client_type`,
	`clients`.`client_status` AS `client_status`,`clients`.`client_number` AS `client_number`,
	`client_accounts`.`client_account_number` AS `client_account_number`,`client_accounts`.`account_status` AS `account_status`,
	`client_accounts`.`currency_code` AS `currency_code`,`bms_brokerage_orders`.`commission` AS `commission`,
	`bms_brokerage_orders`.`levies` AS `levies`,`bms_brokerage_orders`.`net_value` AS `net_value`,
	`bms_brokerage_orders`.`fees` AS `fees` from ((((`bms_brokerage_orders` join `client_accounts`
	 on((`client_accounts`.`client_account_id` = `bms_brokerage_orders`.`client_account_id`))) join `clients`
	on((`clients`.`client_id` = `client_accounts`.`client_id`))) join `branches` on((`clients`.`branch_id` = `branches`.`branch_id`)))
	 join `securities` on((`securities`.`security_id` = `bms_brokerage_orders`.`equity_id`)));
create or replace view `bms_view_brokerage_orders_old` AS select `bms_brokerage_orders`.`brokerage_order_id` AS `brokerage_order_id`,`bms_brokerage_orders`.`branch_id` AS `branch_id`,`bms_brokerage_orders`.`client_account_id` AS `client_account_id`,`bms_brokerage_orders`.`instructions` AS `instructions`,`bms_brokerage_orders`.`equity_id` AS `equity_id`,`bms_brokerage_orders`.`order_number` AS `order_number`,`bms_brokerage_orders`.`reference_number` AS `reference_number`,`bms_brokerage_orders`.`consideration` AS `consideration`,`bms_brokerage_orders`.`order_price` AS `order_price`,`bms_brokerage_orders`.`market_price` AS `market_price`,`bms_brokerage_orders`.`balance` AS `balance`,`bms_brokerage_orders`.`quantity` AS `quantity`,`bms_brokerage_orders`.`amount` AS `amount`,`bms_brokerage_orders`.`charges` AS `charges`,`bms_brokerage_orders`.`transaction_date` AS `transaction_date`,`bms_brokerage_orders`.`order_type` AS `order_type`,`bms_brokerage_orders`.`order_status` AS `order_status`,`bms_brokerage_orders`.`comment` AS `comment`,`bms_brokerage_orders`.`charge_list` AS `charge_list`,`bms_brokerage_orders`.`created_at` AS `created_at`,`bms_brokerage_orders`.`created_by` AS `created_by`,`bms_brokerage_orders`.`updated_at` AS `updated_at`,`bms_brokerage_orders`.`updated_by` AS `updated_by`,/*`securities`.`security_code` AS `security_code`,*/`securities`.`security_description` AS `security_description`,`branches`.`branch_name` AS `branch_Name`,`bms_brokerage_orders`.`actual_quantity` AS `actual_quantity`,`clients`.`client_id` AS `client_id`,`clients`.`client_name` AS `client_name`,`clients`.`client_type` AS `client_type`,`clients`.`client_status` AS `client_status`,`clients`.`client_number` AS `client_number`,`client_accounts`.`client_account_number` AS `client_account_number`,`client_accounts`.`account_status` AS `account_status`,`client_accounts`.`currency_code` AS `currency_code` from ((((`bms_brokerage_orders` join `client_accounts` on((`client_accounts`.`client_account_id` = `bms_brokerage_orders`.`client_account_id`))) join `clients` on((`clients`.`client_id` = `client_accounts`.`client_id`))) join `branches` on((`clients`.`branch_id` = `branches`.`branch_id`))) join `securities` on((`securities`.`security_id` = `bms_brokerage_orders`.`equity_id`)));


commit;
